{
                               Saxman Software
                      Copyright 1995, 1996 Jim Standley

                                Logger Window


Any program can "use" this unit, and write lines to the log.  The code in
the DPR file (View/Project Source) should NOT create this window.  The
logger might make a nice custom control or at least an object with a few
more useful methods some day.

}
unit Logger;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TfLogger = class(TForm)
    ListBox1: TListBox;
    pbClear: TButton;
    cbMessage: TCheckBox;
    pbLine: TButton;
    procedure pbClearClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure pbLineClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fLogger: TfLogger;

procedure Log(LogItem : String);

implementation

{$R *.DFM}
var
   V1, V2, H1 : Integer;
   Destroyed  : Boolean;

procedure MakeNewLog;
begin
   fLogger := TfLogger.Create(Application);
   V1 := fLogger.Height - fLogger.pbClear.Top;
   V2 := fLogger.Height - fLogger.ListBox1.Height;
   H1 := fLogger.Width  - fLogger.ListBox1.Width;
   fLogger.Top  := Screen.Height - fLogger.Height;
   fLogger.Left := Screen.Width  - fLogger.Width;
   fLogger.Show;
   Destroyed := False;
end;

procedure Log;
begin
   if not assigned(fLogger) then
      MakeNewLog;
   if Destroyed then
   begin
      ShowMessage(LogItem);
      exit;
   end;
   fLogger.ListBox1.Items.Add(LogItem);
   fLogger.ListBox1.ItemIndex := fLogger.ListBox1.Items.Count-1;
   fLogger.Refresh;
   if fLogger.cbMessage.State = cbChecked then
      ShowMessage(LogItem);
end;

procedure TfLogger.pbClearClick(Sender: TObject);
begin
   fLogger.ListBox1.Clear;
end;

procedure TfLogger.FormResize(Sender: TObject);
begin
   fLogger.pbClear.Top     := fLogger.Height - V1;
   fLogger.pbLine.Top      := fLogger.Height - V1;
   fLogger.cbMessage.Top   := fLogger.Height - V1;
   fLogger.ListBox1.Height := fLogger.Height - V2;
   fLogger.ListBox1.Width  := fLogger.Width  - H1;
end;

procedure TfLogger.FormDestroy(Sender: TObject);
begin
   Destroyed := True;
end;

procedure TfLogger.FormCreate(Sender: TObject);
begin
   Destroyed := False;
end;

procedure TfLogger.pbLineClick(Sender: TObject);
const
   LineSize = 100;
var
   ShowMessage : Boolean;
   TheLine     : String[LineSize];
begin
   ShowMessage := (fLogger.cbMessage.State = cbChecked);
   fLogger.cbMessage.State := cbUnChecked;
   TheLine[0] := chr(LineSize);
   FillChar(TheLine[1],LineSize,'-');
   Log(TheLine);
   if ShowMessage then
      fLogger.cbMessage.State := cbChecked;
end;

end.
